# 7 "frontend/lexer.mll"
 
open Lexing
open Abstract_syntax
open Parser

let use_line_directives = ref false

let kwd_table = Hashtbl.create 10
let _ = 
  List.iter (fun (a,b) -> Hashtbl.add kwd_table a b)
    [
     "bool", TOK_BOOL;
     "char", TOK_CHAR;
     "short", TOK_SHORT;
     "int", TOK_INT;
     "long", TOK_LONG;
     "integer", TOK_INTEGER;
     "unsigned", TOK_UNSIGNED;
     "float", TOK_FLOAT;
     "double", TOK_DOUBLE;
     "real", TOK_REAL;
     "void", TOK_VOID;
     "while", TOK_WHILE;
     "if", TOK_IF;
     "else", TOK_ELSE;
     "return", TOK_RETURN;
     "break", TOK_BREAK;
     "true", TOK_TRUE;
     "false", TOK_FALSE;
     "input", TOK_INPUT;
     "volatile", TOK_VOLATILE;
     "assert", TOK_ASSERT;
     "assume", TOK_ASSUME;
     "print", TOK_PRINT;
   ]

# 39 "frontend/lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base = 
   "\000\000\001\000\002\000\012\000\000\000\001\000\000\000\064\000\
    \255\255\006\000\007\000\061\000\066\000\013\000\002\000\005\000\
    \014\000\068\000\070\000\011\000\030\000\015\000\038\000\008\000\
    \255\255\018\000\126\000\217\255\076\000\077\000\219\255\226\000\
    \250\000\224\255\231\255\232\255\000\000\000\000\021\000\022\000\
    \023\000\027\000\081\000\030\000\031\000\080\000\083\000\249\255\
    \250\255\251\255\252\255\253\255\254\255\067\001\226\255\248\255\
    \225\255\247\255\229\255\235\255\127\000\221\255\228\255\227\255\
    \238\255\237\255\236\255\234\255\233\255\100\000\142\001\152\001\
    \004\001\083\000\236\000\175\001\207\001\235\001\006\002\016\002\
    \026\002\036\002\246\000\019\000\253\255\254\255\000\000\255\255\
    ";
  Lexing.lex_backtrk = 
   "\002\000\001\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\255\255\255\255\000\000\000\000\
    \255\255\255\255\000\000\000\000\255\255\255\255\255\255\000\000\
    \255\255\000\000\255\255\255\255\037\000\036\000\255\255\032\000\
    \032\000\255\255\255\255\255\255\255\255\255\255\025\000\016\000\
    \015\000\014\000\013\000\012\000\009\000\011\000\010\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\035\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\033\000\255\255\
    \255\255\255\255\032\000\032\000\032\000\255\255\033\000\255\255\
    \033\000\255\255\255\255\002\000\255\255\255\255\001\000\255\255\
    ";
  Lexing.lex_default = 
   "\255\255\255\255\255\255\009\000\255\255\255\255\255\255\255\255\
    \000\000\009\000\010\000\009\000\009\000\013\000\021\000\021\000\
    \010\000\017\000\021\000\021\000\017\000\021\000\021\000\255\255\
    \000\000\255\255\255\255\000\000\255\255\255\255\000\000\255\255\
    \255\255\000\000\000\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\060\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\085\000\255\255\000\000\000\000\255\255\000\000\
    ";
  Lexing.lex_trans = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\001\000\002\000\015\000\001\000\001\000\002\000\
    \008\000\015\000\024\000\025\000\014\000\012\000\008\000\024\000\
    \015\000\011\000\023\000\014\000\008\000\084\000\000\000\000\000\
    \001\000\001\000\002\000\002\000\013\000\000\000\067\000\013\000\
    \019\000\013\000\000\000\018\000\012\000\013\000\010\000\087\000\
    \017\000\013\000\003\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\003\000\003\000\003\000\003\000\012\000\008\000\
    \017\000\007\000\011\000\012\000\008\000\007\000\019\000\011\000\
    \019\000\018\000\066\000\065\000\064\000\028\000\028\000\030\000\
    \063\000\028\000\028\000\059\000\058\000\012\000\022\000\010\000\
    \007\000\022\000\012\000\016\000\010\000\007\000\013\000\022\000\
    \013\000\005\000\016\000\022\000\028\000\028\000\004\000\006\000\
    \003\000\003\000\003\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\020\000\061\000\068\000\057\000\055\000\000\000\
    \060\000\000\000\022\000\074\000\074\000\000\000\000\000\028\000\
    \030\000\255\255\000\000\029\000\255\255\056\000\062\000\081\000\
    \054\000\081\000\000\000\000\000\080\000\080\000\080\000\080\000\
    \080\000\080\000\080\000\080\000\080\000\080\000\028\000\043\000\
    \020\000\000\000\022\000\041\000\037\000\000\000\052\000\051\000\
    \044\000\046\000\033\000\045\000\000\000\042\000\032\000\031\000\
    \031\000\031\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \034\000\035\000\040\000\038\000\039\000\000\000\000\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\050\000\000\000\049\000\000\000\053\000\000\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\048\000\036\000\047\000\000\000\000\000\000\000\000\000\
    \084\000\000\000\255\255\083\000\000\000\255\255\255\255\255\255\
    \000\000\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \070\000\000\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\074\000\074\000\255\255\000\000\
    \086\000\000\000\000\000\000\000\000\000\000\000\255\255\069\000\
    \070\000\000\000\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\075\000\075\000\075\000\075\000\
    \075\000\075\000\075\000\075\000\073\000\255\255\000\000\069\000\
    \000\000\031\000\255\255\000\000\255\255\000\000\255\255\069\000\
    \000\000\072\000\000\000\074\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\071\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\031\000\000\000\000\000\073\000\000\000\000\000\069\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\072\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\071\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\000\000\027\000\255\255\
    \000\000\000\000\000\000\000\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\000\000\000\000\
    \000\000\000\000\053\000\000\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\076\000\000\000\077\000\000\000\000\000\000\000\000\000\
    \000\000\076\000\076\000\076\000\076\000\076\000\076\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\075\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\070\000\000\000\000\000\
    \000\000\000\000\000\000\077\000\000\000\000\000\255\255\000\000\
    \000\000\076\000\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\000\000\000\000\000\000\000\000\000\000\075\000\000\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\079\000\000\000\
    \079\000\000\000\000\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\076\000\000\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \078\000\078\000\080\000\080\000\080\000\080\000\080\000\080\000\
    \080\000\080\000\080\000\080\000\080\000\080\000\080\000\080\000\
    \080\000\080\000\080\000\080\000\080\000\080\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\078\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\080\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\001\000\002\000\014\000\000\000\001\000\002\000\
    \009\000\010\000\023\000\009\000\010\000\003\000\003\000\013\000\
    \016\000\003\000\013\000\016\000\025\000\083\000\255\255\255\255\
    \000\000\001\000\002\000\000\000\014\000\255\255\037\000\015\000\
    \020\000\010\000\255\255\020\000\003\000\019\000\003\000\086\000\
    \016\000\021\000\002\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\002\000\002\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\003\000\003\000\003\000\003\000\011\000\011\000\
    \022\000\007\000\011\000\012\000\012\000\007\000\017\000\012\000\
    \018\000\017\000\038\000\039\000\040\000\028\000\029\000\029\000\
    \041\000\028\000\029\000\043\000\044\000\011\000\014\000\011\000\
    \007\000\015\000\012\000\010\000\012\000\006\000\017\000\019\000\
    \018\000\004\000\016\000\021\000\028\000\029\000\002\000\005\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\020\000\042\000\036\000\045\000\046\000\255\255\
    \042\000\255\255\022\000\073\000\073\000\255\255\255\255\026\000\
    \026\000\060\000\255\255\026\000\060\000\045\000\042\000\069\000\
    \046\000\069\000\255\255\255\255\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\026\000\026\000\
    \017\000\255\255\018\000\026\000\026\000\255\255\026\000\026\000\
    \026\000\026\000\026\000\026\000\255\255\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\255\255\255\255\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\255\255\026\000\255\255\026\000\255\255\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\026\000\026\000\026\000\026\000\
    \026\000\026\000\026\000\026\000\255\255\255\255\255\255\255\255\
    \082\000\255\255\014\000\082\000\255\255\015\000\009\000\010\000\
    \255\255\255\255\255\255\019\000\003\000\013\000\016\000\021\000\
    \031\000\255\255\031\000\031\000\031\000\031\000\031\000\031\000\
    \031\000\031\000\031\000\031\000\074\000\074\000\020\000\255\255\
    \082\000\255\255\255\255\255\255\255\255\255\255\022\000\031\000\
    \032\000\255\255\032\000\032\000\032\000\032\000\032\000\032\000\
    \032\000\032\000\032\000\032\000\072\000\072\000\072\000\072\000\
    \072\000\072\000\072\000\072\000\032\000\011\000\255\255\032\000\
    \255\255\031\000\012\000\255\255\017\000\255\255\018\000\031\000\
    \255\255\032\000\255\255\074\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\032\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\032\000\255\255\255\255\032\000\255\255\255\255\032\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\032\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\032\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\255\255\026\000\060\000\
    \255\255\255\255\255\255\255\255\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\255\255\255\255\
    \255\255\255\255\053\000\255\255\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\053\000\053\000\
    \053\000\053\000\053\000\053\000\053\000\053\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \071\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\255\255\070\000\255\255\255\255\255\255\255\255\
    \255\255\071\000\071\000\071\000\071\000\071\000\071\000\075\000\
    \075\000\075\000\075\000\075\000\075\000\075\000\075\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\070\000\255\255\255\255\
    \255\255\255\255\255\255\070\000\255\255\255\255\082\000\255\255\
    \255\255\071\000\071\000\071\000\071\000\071\000\071\000\076\000\
    \076\000\076\000\076\000\076\000\076\000\076\000\076\000\076\000\
    \076\000\255\255\255\255\255\255\255\255\255\255\075\000\255\255\
    \076\000\076\000\076\000\076\000\076\000\076\000\077\000\255\255\
    \077\000\255\255\255\255\077\000\077\000\077\000\077\000\077\000\
    \077\000\077\000\077\000\077\000\077\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\076\000\255\255\
    \076\000\076\000\076\000\076\000\076\000\076\000\078\000\078\000\
    \078\000\078\000\078\000\078\000\078\000\078\000\078\000\078\000\
    \079\000\079\000\079\000\079\000\079\000\079\000\079\000\079\000\
    \079\000\079\000\080\000\080\000\080\000\080\000\080\000\080\000\
    \080\000\080\000\080\000\080\000\081\000\081\000\081\000\081\000\
    \081\000\081\000\081\000\081\000\081\000\081\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\078\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\080\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255";
  Lexing.lex_base_code = 
   "\000\000\000\000\000\000\010\000\000\000\000\000\000\000\059\000\
    \012\000\000\000\000\000\002\000\003\000\000\000\004\000\005\000\
    \006\000\007\000\008\000\009\000\011\000\012\000\013\000\000\000\
    \033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_backtrk_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\012\000\000\000\000\000\012\000\012\000\
    \000\000\000\000\033\000\033\000\000\000\000\000\000\000\033\000\
    \000\000\012\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_default_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\019\000\000\000\000\000\000\000\019\000\019\000\
    \019\000\027\000\019\000\019\000\027\000\019\000\019\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    ";
  Lexing.lex_trans_code = 
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\001\000\000\000\000\000\000\000\001\000\000\000\000\000\
    \000\000\000\000\027\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \001\000\000\000\000\000\001\000\022\000\022\000\000\000\000\000\
    \027\000\030\000\030\000\030\000\007\000\042\000\000\000\027\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\001\000\000\000\000\000\000\000\
    \001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\001\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\001\000\000\000\000\000\
    \000\000\000\000\000\000\004\000\004\000\004\000\004\000\004\000\
    \004\000\004\000\004\000\004\000\004\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000";
  Lexing.lex_check_code = 
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\002\000\255\255\255\255\255\255\002\000\255\255\255\255\
    \255\255\255\255\018\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \002\000\255\255\010\000\000\000\011\000\012\000\014\000\015\000\
    \016\000\017\000\018\000\019\000\003\000\020\000\021\000\022\000\
    \002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\003\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\003\000\003\000\007\000\255\255\255\255\255\255\
    \007\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\007\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\006\000\255\255\255\255\
    \255\255\255\255\255\255\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \010\000\255\255\255\255\255\255\014\000\015\000\016\000\017\000\
    \018\000\019\000\255\255\020\000\021\000\022\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255";
  Lexing.lex_code = 
   "\255\004\255\255\005\255\255\007\255\006\255\255\003\255\000\004\
    \001\005\255\007\255\255\006\255\007\255\255\008\255\255\007\008\
    \255\000\004\001\005\003\006\002\007\255\007\008\008\255\255";
}

let rec start_token lexbuf =
  lexbuf.Lexing.lex_mem <- Array.create 9 (-1) ;   __ocaml_lex_start_token_rec lexbuf 0
and __ocaml_lex_start_token_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 70 "frontend/lexer.mll"
                                       line
# 419 "frontend/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 71 "frontend/lexer.mll"
                      file
# 424 "frontend/lexer.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(3) lexbuf.Lexing.lex_mem.(2) in
# 72 "frontend/lexer.mll"
( 
  new_line lexbuf;
  if !use_line_directives then
    lexbuf.lex_curr_p <- 
      { lexbuf.lex_curr_p with
        pos_lnum = int_of_string line;
        pos_fname = 
        match file with Some x -> x | None -> lexbuf.lex_curr_p.pos_fname;
      };
  start_token lexbuf 
)
# 438 "frontend/lexer.ml"

  | 1 ->
# 85 "frontend/lexer.mll"
( start_token lexbuf )
# 443 "frontend/lexer.ml"

  | 2 ->
# 88 "frontend/lexer.mll"
( token lexbuf )
# 448 "frontend/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_start_token_rec lexbuf __ocaml_lex_state

and token lexbuf =
    __ocaml_lex_token_rec lexbuf 26
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 94 "frontend/lexer.mll"
                                                          id
# 460 "frontend/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 95 "frontend/lexer.mll"
( try Hashtbl.find kwd_table id with Not_found -> TOK_id id )
# 464 "frontend/lexer.ml"

  | 1 ->
# 98 "frontend/lexer.mll"
         ( TOK_LPAREN )
# 469 "frontend/lexer.ml"

  | 2 ->
# 99 "frontend/lexer.mll"
         ( TOK_RPAREN )
# 474 "frontend/lexer.ml"

  | 3 ->
# 100 "frontend/lexer.mll"
         ( TOK_LBRACKET )
# 479 "frontend/lexer.ml"

  | 4 ->
# 101 "frontend/lexer.mll"
         ( TOK_RBRACKET )
# 484 "frontend/lexer.ml"

  | 5 ->
# 102 "frontend/lexer.mll"
         ( TOK_LCURLY )
# 489 "frontend/lexer.ml"

  | 6 ->
# 103 "frontend/lexer.mll"
         ( TOK_RCURLY )
# 494 "frontend/lexer.ml"

  | 7 ->
# 104 "frontend/lexer.mll"
         ( TOK_PLUS_PLUS )
# 499 "frontend/lexer.ml"

  | 8 ->
# 105 "frontend/lexer.mll"
         ( TOK_MINUS_MINUS )
# 504 "frontend/lexer.ml"

  | 9 ->
# 106 "frontend/lexer.mll"
         ( TOK_STAR )
# 509 "frontend/lexer.ml"

  | 10 ->
# 107 "frontend/lexer.mll"
         ( TOK_PLUS )
# 514 "frontend/lexer.ml"

  | 11 ->
# 108 "frontend/lexer.mll"
         ( TOK_MINUS )
# 519 "frontend/lexer.ml"

  | 12 ->
# 109 "frontend/lexer.mll"
         ( TOK_EXCLAIM )
# 524 "frontend/lexer.ml"

  | 13 ->
# 110 "frontend/lexer.mll"
         ( TOK_DIVIDE )
# 529 "frontend/lexer.ml"

  | 14 ->
# 111 "frontend/lexer.mll"
         ( TOK_PERCENT )
# 534 "frontend/lexer.ml"

  | 15 ->
# 112 "frontend/lexer.mll"
         ( TOK_LESS )
# 539 "frontend/lexer.ml"

  | 16 ->
# 113 "frontend/lexer.mll"
         ( TOK_GREATER )
# 544 "frontend/lexer.ml"

  | 17 ->
# 114 "frontend/lexer.mll"
         ( TOK_LESS_EQUAL )
# 549 "frontend/lexer.ml"

  | 18 ->
# 115 "frontend/lexer.mll"
         ( TOK_GREATER_EQUAL )
# 554 "frontend/lexer.ml"

  | 19 ->
# 116 "frontend/lexer.mll"
         ( TOK_EQUAL_EQUAL )
# 559 "frontend/lexer.ml"

  | 20 ->
# 117 "frontend/lexer.mll"
         ( TOK_NOT_EQUAL )
# 564 "frontend/lexer.ml"

  | 21 ->
# 118 "frontend/lexer.mll"
         ( TOK_AND_AND )
# 569 "frontend/lexer.ml"

  | 22 ->
# 119 "frontend/lexer.mll"
         ( TOK_BAR_BAR )
# 574 "frontend/lexer.ml"

  | 23 ->
# 120 "frontend/lexer.mll"
         ( TOK_SEMICOLON )
# 579 "frontend/lexer.ml"

  | 24 ->
# 121 "frontend/lexer.mll"
         ( TOK_COLON )
# 584 "frontend/lexer.ml"

  | 25 ->
# 122 "frontend/lexer.mll"
         ( TOK_EQUAL )
# 589 "frontend/lexer.ml"

  | 26 ->
# 123 "frontend/lexer.mll"
         ( TOK_STAR_EQUAL )
# 594 "frontend/lexer.ml"

  | 27 ->
# 124 "frontend/lexer.mll"
         ( TOK_DIVIDE_EQUAL )
# 599 "frontend/lexer.ml"

  | 28 ->
# 125 "frontend/lexer.mll"
         ( TOK_PERCENT_EQUAL )
# 604 "frontend/lexer.ml"

  | 29 ->
# 126 "frontend/lexer.mll"
         ( TOK_PLUS_EQUAL )
# 609 "frontend/lexer.ml"

  | 30 ->
# 127 "frontend/lexer.mll"
         ( TOK_MINUS_EQUAL )
# 614 "frontend/lexer.ml"

  | 31 ->
# 128 "frontend/lexer.mll"
         ( TOK_COMMA )
# 619 "frontend/lexer.ml"

  | 32 ->
let
# 131 "frontend/lexer.mll"
                  c
# 625 "frontend/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 131 "frontend/lexer.mll"
                    ( TOK_int_literal c )
# 629 "frontend/lexer.ml"

  | 33 ->
let
# 132 "frontend/lexer.mll"
                  c
# 635 "frontend/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_curr_pos in
# 132 "frontend/lexer.mll"
                    ( TOK_float_literal c )
# 639 "frontend/lexer.ml"

  | 34 ->
# 135 "frontend/lexer.mll"
       ( comment lexbuf; token lexbuf )
# 644 "frontend/lexer.ml"

  | 35 ->
# 136 "frontend/lexer.mll"
                      ( token lexbuf )
# 649 "frontend/lexer.ml"

  | 36 ->
# 137 "frontend/lexer.mll"
          ( new_line lexbuf; start_token lexbuf )
# 654 "frontend/lexer.ml"

  | 37 ->
# 138 "frontend/lexer.mll"
        ( token lexbuf )
# 659 "frontend/lexer.ml"

  | 38 ->
# 140 "frontend/lexer.mll"
      ( TOK_EOF )
# 664 "frontend/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_token_rec lexbuf __ocaml_lex_state

and comment lexbuf =
    __ocaml_lex_comment_rec lexbuf 82
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 145 "frontend/lexer.mll"
       ( () )
# 675 "frontend/lexer.ml"

  | 1 ->
# 146 "frontend/lexer.mll"
                ( comment lexbuf )
# 680 "frontend/lexer.ml"

  | 2 ->
# 147 "frontend/lexer.mll"
          ( new_line lexbuf; comment lexbuf )
# 685 "frontend/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf; __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

;;

