(*   
     HTML helpers.
     
     Copyright (C) 2012 Antoine Miné
 *)


open Http


let doctype = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">"

let doctype_frameset = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">"


(* escapes len chars from pos from s *)
let html_escape_buf space (o:out_channel) (s:string) (pos:int) (len:int) =
  for i=pos to pos+len-1 do match s.[i] with
  | '<' -> output_string o "&lt;"
  | '>' -> output_string o "&gt;"
  | '&' -> output_string o "&amp;"
  | '\"' -> output_string o "&quot;"
  | '\n' when space -> output_string o "<br>\r\n"
  | ' ' when space -> output_string o "&nbsp;"
  | '\t' when space -> output_string o "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"
  | '\t' -> output_string o "        "
  | c -> output_char o c
  done


(* output str escaped *)
let html_escape (o:out_channel) (str:string) =
  html_escape_buf false o str 0 (String.length str)
    

    
(* formatter *)
let html_formatter (h:http) : Format.formatter =
  let out = html_escape_buf true h.http_out
  and flush () = flush h.http_out
  and newlines () = hstring h "<br>\r\n"
  and spaces i = for j=1 to i do hstring h "&nbsp;"; done
  and open_tag t = "<"^t^">"
  and close_tag t =
    let prefix = try String.sub t 0 (String.index t ' ') with Not_found -> t in
    if prefix = "p" || prefix = "br" then "" 
    else "</"^prefix^">"
  in
  let f = Format.make_formatter out flush in
  Format.pp_set_all_formatter_output_functions f out flush newlines spaces;
  Format.pp_set_formatter_tag_functions f
    { Format.mark_open_tag  = open_tag;
      Format.mark_close_tag = close_tag;
      Format.print_open_tag = (fun _ -> ());
      Format.print_close_tag = (fun _ -> ());
    };
  f
    
