(*   
     Simple CGI test.
     
     Copyright (C) 2012 Antoine Miné
*)

open Http
open Html

let handle (h:http) =
  http_header h;
  hprintf h "%s\r\n" doctype;
  hprintf h "<html>\r\n<head><title>OCaml CGI Test</title></head>\r\n";
  hprintf h "<body>\r\n<h1>OCaml CGI Test</h2>\r\n";
  hprintf h "<h2>Parsed request</h2>\r\n";
  hprintf h "Version: 1.%i<br>\r\n" h.http_ver;
  hprintf h "URI: %a<br>\r\n" html_escape (Uri.to_string h.http_uri);
  List.iter (fun (a,b) -> hprintf h "Cookie: %a = %a<br>\r\n" html_escape a html_escape b) h.http_cookies;
  List.iter (fun (a,b) -> hprintf h "Posted: %a = %a<br>\r\n" html_escape a html_escape b) h.http_post;
  hprintf h "Referer: %a<br>\r\n" html_escape (match h.http_referer with Some x -> Uri.to_string x | None -> "<none>");
  hprintf h "CGI: %B<br>\r\n" h.http_cgi;
  hprintf h "Address: %a<br>\r\n" html_escape (Unix.string_of_inet_addr h.http_addr);
  hprintf h "User-agent: %a<br>\r\n" html_escape h.http_user_agent;
  hprintf h "<h2>Raw environment</h2>\r\n";
  Array.iter (fun a -> hprintf h "%a<br>\r\n" html_escape a) (Unix.environment ());
  hprintf h "</body></html>\r\n"

let _ = cgi_answerer handle
